unit Brushes_U;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Resources;

type
  TSize = System.Drawing.Size;
  TPoint = System.Drawing.Point;
  TBrush = System.Drawing.Brush;
  TBitmap = System.Drawing.Bitmap;
  TImage = System.Drawing.Image;
  TRectangle = System.Drawing.Rectangle;
  TGraphics = System.Drawing.Graphics;
  TSolidBrush = System.Drawing.SolidBrush;
  TTextureBrush = System.Drawing.TextureBrush;
  TColor = System.Drawing.Color;
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Button1: System.Windows.Forms.Button;
    Button2: System.Windows.Forms.Button;
    Button3: System.Windows.Forms.Button;
    Button4: System.Windows.Forms.Button;
    Button5: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure Button3_Click(sender: System.Object; e: System.EventArgs);
    procedure Button4_Click(sender: System.Object; e: System.EventArgs);
    procedure Button5_Click(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_Paint(sender: System.Object; e: System.Windows.Forms.PaintEventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    BackgroundBrush: TBrush;
    ColorBars: TImage;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

uses System.Drawing.Drawing2D,System.Drawing.Text;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TWinForm));
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.Button3 := System.Windows.Forms.Button.Create;
  Self.Button4 := System.Windows.Forms.Button.Create;
  Self.Button5 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(8, 16);
  Self.Button1.Name := 'Button1';
  Self.Button1.Size := System.Drawing.Size.Create(88, 24);
  Self.Button1.TabIndex := 0;
  Self.Button1.Text := 'Create JPG';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(104, 16);
  Self.Button2.Name := 'Button2';
  Self.Button2.Size := System.Drawing.Size.Create(88, 24);
  Self.Button2.TabIndex := 1;
  Self.Button2.Text := 'Alpha Blend';
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // Button3
  // 
  Self.Button3.Location := System.Drawing.Point.Create(200, 16);
  Self.Button3.Name := 'Button3';
  Self.Button3.Size := System.Drawing.Size.Create(88, 24);
  Self.Button3.TabIndex := 2;
  Self.Button3.Text := 'White Wash';
  Include(Self.Button3.Click, Self.Button3_Click);
  // 
  // Button4
  // 
  Self.Button4.Location := System.Drawing.Point.Create(296, 16);
  Self.Button4.Name := 'Button4';
  Self.Button4.Size := System.Drawing.Size.Create(88, 24);
  Self.Button4.TabIndex := 3;
  Self.Button4.Text := 'Gradient';
  Include(Self.Button4.Click, Self.Button4_Click);
  // 
  // Button5
  // 
  Self.Button5.Location := System.Drawing.Point.Create(392, 16);
  Self.Button5.Name := 'Button5';
  Self.Button5.Size := System.Drawing.Size.Create(88, 24);
  Self.Button5.TabIndex := 4;
  Self.Button5.Text := 'Path Gradient';
  Include(Self.Button5.Click, Self.Button5_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.BackgroundImage := (System.Drawing.Image(resources.GetObject('$this.B' +
    'ackgroundImage')));
  Self.ClientSize := System.Drawing.Size.Create(496, 486);
  Self.Controls.Add(Self.Button5);
  Self.Controls.Add(Self.Button4);
  Self.Controls.Add(Self.Button3);
  Self.Controls.Add(Self.Button2);
  Self.Controls.Add(Self.Button1);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm';
  Include(Self.Paint, Self.TWinForm_Paint);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

// We can subclass and override the OnPaint method.
procedure TWinForm.TWinForm_Paint(sender: System.Object; e: System.Windows.Forms.PaintEventArgs);
var
  g: TGraphics;
  hb: HatchBrush;
begin
  g:= e.Graphics;

  // Use brushes to paint on the client area.
  g.FillRectangle(TSolidBrush.Create(Color.Red), 40, 60, 140, 140);
  g.FillRectangle(TSolidBrush.Create(Color.Green), 60, 80, 140, 140);

  // Brushes can either be solid, hatched, textured, or gradiated.
  hb:= HatchBrush.Create(HatchStyle.ForwardDiagonal, Color.Green, Color.FromArgb(100, Color.Yellow));
  g.FillEllipse(hb, 10, 120, 100, 100);
end;

// A PathGradient brush allows for the creation of much more complex effects, such as the following shape.
procedure TWinForm.Button5_Click(sender: System.Object; e: System.EventArgs);
var
  g: TGraphics;
  Path: GraphicsPath;
  points: array[0..5] of TPoint;
  types: array[0..5] of Byte;
  colors: array[0..5] of TColor;
  pgb: PathGradientBrush;
begin
  g:= CreateGraphics;
  g.TextRenderingHint:= TextRenderingHint.AntiAlias;

  points[0]:= TPoint.Create(40, 240);
  points[1]:= TPoint.Create(275, 300);
  points[2]:= TPoint.Create(105, 325);
  points[3]:= TPoint.Create(190, 400);
  points[4]:= TPoint.Create(50, 450);
  points[5]:= TPoint.Create(20, 280);

  types[0]:= Byte(PathPointType.Start);
  types[1]:= Byte(PathPointType.Bezier);
  types[2]:= Byte(PathPointType.Bezier);
  types[3]:= Byte(PathPointType.Bezier);
  types[4]:= Byte(PathPointType.Line);
  types[5]:= Byte(PathPointType.Line);

  Path:= GraphicsPath.Create(points, types);

  pgb:= PathGradientBrush.Create(Path);

  colors[0]:= Color.Green;
  colors[1]:= Color.Yellow;
  colors[2]:= Color.Red;
  colors[3]:= Color.Blue;
  colors[4]:= Color.Orange;
  colors[5]:= Color.Brown;

  pgb.SurroundColors:= colors;
  g.FillPath(pgb, path);
end;

procedure TWinForm.Button4_Click(sender: System.Object; e: System.EventArgs);
var
  g: TGraphics;
  R: TRectangle;
  lb: LinearGradientBrush;
begin
  g:= CreateGraphics;

  r:= TRectangle.Create(220, 180, 100, 100);
  lb:= LinearGradientBrush.Create(r, Color.Red, Color.Yellow,LinearGradientMode.BackwardDiagonal);
  g.FillRectangle(lb, r);
end;

// Applies a white "wash" over the client area to tone down the colors in the bitmap..
procedure TWinForm.Button3_Click(sender: System.Object; e: System.EventArgs);
var
  g: TGraphics;
begin
  g:= CreateGraphics;
  g.FillRectangle(TSolidBrush.Create(Color.FromArgb(180, Color.White)), ClientRectangle);
end;

procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
var
  g: TGraphics;
begin
  g:= CreateGraphics;

  g.FillRectangle(TSolidBrush.Create(Color.Blue), 220, 60, 100, 100);
  g.FillRectangle(TSolidBrush.Create(Color.FromArgb(100, Color.Yellow)), 260, 110, 100, 100);
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  newBitmap: TBitmap;
  g: TGraphics;
begin
  newBitmap:= TBitmap.Create(600,400);

  g:= Graphics.FromImage(newBitmap);
  g.FillRectangle(TSolidBrush.Create(Color.Blue), ClientRectangle);
  g.FillRectangle(TSolidBrush.Create(Color.Red), 40, 40, 140, 140);

  newBitmap.Save('TestImage.jpg');
  MessageBox.Show('File TestImage.jpg created!');
end;

end.
